// SearchNVS.cpp : implementation file
//

#include "stdafx.h"
#include "NetDecoder.h"
#include "SearchNVS.h"
#include "Include/CLS_NetAdmin_Interface.h"
#include "Include/CLS_NsLook_Interface.h"
#include "Include/CommonFun.h"
#include <process.h>
#include "Include/CLS_NVDSDK_Interface.h"
#include <string>
#define MSG_NETADMIN_UPDATE_LIST		WM_USER+100
#define MSG_SEARCHNVS_ADDNVS_ITEM		WM_USER+101

// CSearchNVS dialog

unsigned __stdcall AddNvsThreadFunc( void* pvParam )
{
	CSearchNVS* pThis = (CSearchNVS*)pvParam;

	if (pThis)
	{
		POSITION posItem = pThis->m_lvServer.GetFirstSelectedItemPosition();
		while(posItem)
		{
			int iItem = pThis->m_lvServer.GetNextSelectedItem(posItem);
			//pThis->AddNvs(iItem);			
			pThis->PostMessage(MSG_SEARCHNVS_ADDNVS_ITEM,0,(LPARAM)iItem);
			Sleep(600);
		}
		pThis->SendMsgToMainDlg(MSG_ADDNVSITEM, 0, NULL);
	}

	return 0;
}

CSearchNVS* CSearchNVS::m_pSelf = NULL;
HWND CSearchNVS::s_hWnd = NULL;

IMPLEMENT_DYNAMIC(CSearchNVS, CDialog)
CSearchNVS::CSearchNVS(CWnd* pParent /*=NULL*/)
	: CDialog(CSearchNVS::IDD, pParent)
{
	m_pSelf = this;
	m_hThread = NULL;
	m_iID = -1;
	m_iRegPort = 6004;
	m_iConnetMode = 0;
	m_blRefresh = false;
	m_blExit = false;
	m_iRegID = -1;
	m_pdlgMainView = NULL;
	memset(m_cRegIP,0,sizeof(m_cRegIP));
	memset(m_cRegUser,0,sizeof(m_cRegUser));
	memset(m_cRegPwd,0,sizeof(m_cRegPwd));

	m_hAddThread = NULL;

	m_hLogonRegThread = NULL;
	m_dwThreadID = -1;
	
	InitializeProductModelName();
	InitializeDeviceTypeName();
}

CSearchNVS::~CSearchNVS()
{
	m_pSelf = NULL;

	m_hLogonRegThread = NULL;
	m_dwThreadID = -1;
}

void CSearchNVS::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	DDX_Control(pDX, IDC_LIST_SERVER, m_lvServer);
	DDX_Control(pDX, IDC_COMBO_CONNECT_MODE, m_cboConnectMode);
	DDX_Control(pDX, IDC_COMBO_LOCAL_IP, m_cboServerInterface);
}

BEGIN_MESSAGE_MAP(CSearchNVS, CDialog)
	ON_WM_CLOSE()
	ON_WM_DESTROY()
	ON_BN_CLICKED(IDC_BUTTON_REFREASH, &CSearchNVS::OnBnClickedButtonRefresh)
	ON_BN_CLICKED(IDC_BUTTON_ADD, &CSearchNVS::OnBnClickedButtonAdd)
	ON_CBN_SELCHANGE(IDC_COMBO_CONNECT_MODE, &CSearchNVS::OnCbnSelchangeComboConnectMode)
	ON_NOTIFY(NM_DBLCLK, IDC_LIST_SERVER, &CSearchNVS::OnNMDblclkListServer)
	ON_WM_SHOWWINDOW()
	ON_MESSAGE(MSG_NETADMIN_UPDATE_LIST,&CSearchNVS::OnUpdateList)
	ON_CBN_SELCHANGE(IDC_COMBO_LOCAL_IP, &CSearchNVS::OnCbnSelchangeComboLocalIp)
	ON_MESSAGE(MSG_SEARCHNVS_ADDNVS_ITEM,&CSearchNVS::OnAddNvsItem)
END_MESSAGE_MAP()

BOOL CSearchNVS::OnInitDialog()
{
	CDialog::OnInitDialog();

	SetWindowText(GetText(IDS_MAIN_ADVANCE_ADD));
	SetDlgItemText(IDC_STATIC_SERVERLIST,GetText(IDS_MAIN_SERVER_LIST));
	SetDlgItemText(IDC_STATIC_CONNECT_MODE,GetText(IDS_SEARCH_CONNECT_MODE));
	SetDlgItemText(IDC_BUTTON_ADD,GetText(IDS_SEARCH_ADD));
	SetDlgItemText(IDC_BUTTON_REFREASH,GetText(IDS_SEARCH_REFRESH));
	SetDlgItemText(IDC_STATIC_LOCAL_IP, GetText(IDS_SEARCHNVSDLG_LOCAL_IP));
	m_lvServer.SetExtendedStyle(LVS_EX_GRIDLINES|LVS_EX_FULLROWSELECT);
	m_lvServer.InsertColumn(0,GetText(IDS_MAIN_SERVER_IP),LVCFMT_LEFT,90);
	m_lvServer.InsertColumn(1,GetText(IDS_MAIN_CHANNEL),LVCFMT_LEFT,60);
	m_lvServer.InsertColumn(2,GetText(IDS_MAIN_PORT),LVCFMT_LEFT,60);
	m_lvServer.InsertColumn(3,GetText(IDS_SEARCH_SERVER_TYPE),LVCFMT_LEFT,90);
	m_lvServer.InsertColumn(4,GetText(IDS_SEARCH_FACTORY_ID),LVCFMT_LEFT,160);
	m_lvServer.InsertColumn(5,GetText(IDS_SEARCH_SERVER_NAME),LVCFMT_LEFT,115);
	m_lvServer.InsertColumn(6,GetText(IDS_MAIN_PROXY_IP),LVCFMT_LEFT,90);	

	m_lvServer.SetSortType(0,SORT_TYPE_IP);
	m_lvServer.SetSortType(1,SORT_TYPE_INT);
	m_lvServer.SetSortType(2,SORT_TYPE_INT);
	m_lvServer.SetSortType(3,SORT_TYPE_STRING);
	m_lvServer.SetSortType(4,SORT_TYPE_STRING);
	m_lvServer.SetSortType(5,SORT_TYPE_STRING);
	m_lvServer.SetSortType(6,SORT_TYPE_IP);

	if(CLS_NetAdmin_Interface::LoadDLL())
	{
		s_hWnd = this->GetSafeHwnd();

		//if(NetAdmin_Startup() == 1)
		{
			NetAdmin_SetNotify(&CSearchNVS::GetIPList);
			m_cboConnectMode.AddString(GetText(IDS_MAIN_CONNECT_MODE_IP));
			m_cboConnectMode.SetCurSel(0);
			m_iConnetMode = 0;

			if (CLS_NsLook_Interface::LoadDLL())
			{
				m_cboConnectMode.AddString(GetText(IDS_MAIN_CONNECT_MODE_DDNS));
				m_cboConnectMode.AddString(GetText(IDS_MAIN_CONNECT_MODE_DSM));	
			}

			//m_cboConnectMode.AddString(GetText(IDS_MAIN_CONNECT_MODE_ONVIF));

			m_cboServerInterface.ResetContent();
			m_cboServerInterface.AddString("AUTO");
			CString strIP;
			int j = 0;
			while(NetAdmin_GetNetInterface(j))
			{
				strIP = NetAdmin_GetNetInterface(j);
				m_cboServerInterface.AddString(strIP);
				j++;
			}
			m_cboServerInterface.SetCurSel(0);
		}
	}

	return TRUE;  
}

void CSearchNVS::OnDestroy()
{
	if (NULL != m_hAddThread)
	{
		if(WaitForSingleObject(m_hAddThread, INFINITE) != WAIT_OBJECT_0)
		{
			//SuspendThread(m_hAddThread);
			//TerminateThread(m_hAddThread, 0);
		}
		CloseHandle(m_hAddThread);
		m_hAddThread = NULL;
	}

	if(NSLook_Cleanup)
	{
		NSLook_Cleanup();
	}
	
	CLS_NsLook_Interface::FreeDLL();

	CDialog::OnDestroy();
}

int CSearchNVS::Init(int _iID,CMainViewDlg* _pdlgMainView)
{
	m_iID = _iID;
	m_pdlgMainView = _pdlgMainView;

	TDECPARAM tDecParam = {0};
	int iRet = DEC_ClientGetDecoderPara(m_iID,&tDecParam);
	if (iRet==0)
	{	
		m_strHostIP.Format(_T("%s"),tDecParam.m_ip);
		m_iRegPort = tDecParam.m_ddnsPort;
		tDecParam.m_ddnsIP[15] = 0;
		strcpy_s(m_cRegIP,sizeof(tDecParam.m_ddnsIP),tDecParam.m_ddnsIP);
		strcpy_s(m_cRegUser,sizeof(tDecParam.m_ddnsUser),tDecParam.m_ddnsUser);
		strcpy_s(m_cRegPwd,sizeof(tDecParam.m_ddnsPass),tDecParam.m_ddnsPass);
	}
	else
	{
		AddLog(LOG_LEVEL_ERROR,"[CSearchNVS] Get Decoder Param Failed! ID(%d)",m_iID);
	}

	return 0;
}

void CSearchNVS::InitializeProductModelName()
{
	INSERT_PRODUCTMODEL(TC_NVSS);
	INSERT_PRODUCTMODEL(TC_NS621S);
	INSERT_PRODUCTMODEL(TC_NS621S_USB);
	INSERT_PRODUCTMODEL(TC_NS224S);
	INSERT_PRODUCTMODEL(TC_NC621S);
	INSERT_PRODUCTMODEL(TC_NC8000S);
	INSERT_PRODUCTMODEL(TC_NC8001S);
	INSERT_PRODUCTMODEL(TC_NC8100S);
	INSERT_PRODUCTMODEL(TC_NC8101S);
	INSERT_PRODUCTMODEL(TC_NC8200S);
	INSERT_PRODUCTMODEL(TC_NC8700S2);
	INSERT_PRODUCTMODEL(TC_NC8250);
	INSERT_PRODUCTMODEL(TC_NC9010S2_MP);
	INSERT_PRODUCTMODEL(TC_NC9000S2_2MP);
	INSERT_PRODUCTMODEL(TC_NC9010N1_2MP);
	INSERT_PRODUCTMODEL(TC_NC9000S3_3MP);
	INSERT_PRODUCTMODEL(TC_NH9106N1_2MPIR);
	INSERT_PRODUCTMODEL(TC_CC9118_MP_E);
	INSERT_PRODUCTMODEL(TC_NC9100S3_3MP_IR30);
	INSERT_PRODUCTMODEL(TC_NT9054S2_MPIR);
	INSERT_PRODUCTMODEL(TC_NS621S2);
	INSERT_PRODUCTMODEL(TC_NS324S2);
	INSERT_PRODUCTMODEL(TC_NS628S2);
	INSERT_PRODUCTMODEL(TC_NC9010I_2MP);
	INSERT_PRODUCTMODEL(TC_NC9000I_5MP);
	INSERT_PRODUCTMODEL(TC_2816AN_SH);
	INSERT_PRODUCTMODEL(TC_2808AN_S_3511);
	INSERT_PRODUCTMODEL(TC_2816AN_SD);
	INSERT_PRODUCTMODEL(TC_2816AN_SD_E);
	INSERT_PRODUCTMODEL(TC_2808AN_S_3515);
	INSERT_PRODUCTMODEL(TC_2804AN_MX);
	INSERT_PRODUCTMODEL(TC_2816AN_S);
	INSERT_PRODUCTMODEL(TC_H802BHX_T);
	INSERT_PRODUCTMODEL(TC_2832AN_SS);
	INSERT_PRODUCTMODEL(TC_1002S2_3C);
	INSERT_PRODUCTMODEL(TC_ND921S2_MP);
	INSERT_PRODUCTMODEL(TC_ND921S2_2MP);
	INSERT_PRODUCTMODEL(TC_2800AN_SF_L_H);
	INSERT_PRODUCTMODEL(TC_2800AN_SF_H);
	INSERT_PRODUCTMODEL(TC_2804AN_SA);
	INSERT_PRODUCTMODEL(TC_2800AN_SF_L);
	INSERT_PRODUCTMODEL(TC_2800AN_SF);

	INSERT_PRODUCTMODEL(TC_2804AN_SDI);

	INSERT_PRODUCTMODEL(TC_FS0013ERS_HD);         // ޸ĸ岥
	INSERT_PRODUCTMODEL(TC_NC9100S3E_MP_IR30);    //
	INSERT_PRODUCTMODEL(TC_NC9000S3_2MP_E);       // 200W 콨Ŀ
	INSERT_PRODUCTMODEL(TC_NC9200S3_MP_E_IR15);   // ֮ǰproductmodel 0x0059,Ŀ
	INSERT_PRODUCTMODEL(TC_NC9100S1_MP_IR);       // 0xC0046,Ŀ
	INSERT_PRODUCTMODEL(TC_NS921S3_HD_V1);        // 0xC0056,Ŀ ֮ǰTC_NS921_N1_2MP豸Ϊ˿
	INSERT_PRODUCTMODEL(TC_NC9000S3_MP_E);        // ѧĿ
	INSERT_PRODUCTMODEL(TC_2804AN_SQ);
	INSERT_PRODUCTMODEL(TC_2808AN_SF_L);

	INSERT_PRODUCTMODEL(TC_ND921S2_SDI)
	INSERT_PRODUCTMODEL(TC_21X_R2);
	INSERT_PRODUCTMODEL(TC_21X_R3);
	INSERT_PRODUCTMODEL(TC_21X_R5);

	//  
	INSERT_PRODUCTMODEL(TC_NH9206S3_2MP_IVS);
	INSERT_PRODUCTMODEL(TC_NC9000S3E_MP);
	INSERT_PRODUCTMODEL(TC_NC9200S3E_MP_IR);

	//add by bo 20140725
	INSERT_PRODUCTMODEL(TC_2804AN_SR_L);
	INSERT_PRODUCTMODEL(TC_H804I_HD_BP);
	INSERT_PRODUCTMODEL(TC_H904B_HD_V6_X);
	INSERT_PRODUCTMODEL(TC_H908NC_HD);
	INSERT_PRODUCTMODEL(TC_NC9100S3E_2MP_IR30);
	INSERT_PRODUCTMODEL(TC_NC9000S3E_2MP);
	INSERT_PRODUCTMODEL(TC_NC9200S3E_2MP_IR);
	INSERT_PRODUCTMODEL(TC_NC921S3E_MP_HD_C);
	INSERT_PRODUCTMODEL(TC_NH9406S3E_MPIR);
	INSERT_PRODUCTMODEL(TC_NH9406S3E_2MPIR);
	INSERT_PRODUCTMODEL(TC_NC9320S3E_2MP_E);
	INSERT_PRODUCTMODEL(TC_NC9320S3E_MP_E);								
	INSERT_PRODUCTMODEL(TC_218_T5);
	INSERT_PRODUCTMODEL(TC_218_T3H);
	INSERT_PRODUCTMODEL(TC_217_T5);
	INSERT_PRODUCTMODEL(TC_217_T3H);
	INSERT_PRODUCTMODEL(TC_NH9X06S6_XMPIR_A);
	INSERT_PRODUCTMODEL(TC_NH9X06S6_XMPIR_T);														
	INSERT_PRODUCTMODEL(TC_H804BE_HD);				
	INSERT_PRODUCTMODEL(TC_H804N_HD);						
	INSERT_PRODUCTMODEL(TC_2800AN_SF_L_H);		
	INSERT_PRODUCTMODEL(TC_2800AN_SF_H);				
	INSERT_PRODUCTMODEL(TC_2800AN_SF_L);			
	INSERT_PRODUCTMODEL(TC_2800AN_SF);		
	INSERT_PRODUCTMODEL(TC_H804BE_P);	
	INSERT_PRODUCTMODEL(TC_2800AN_R16_S2);
	INSERT_PRODUCTMODEL(TC_2804AN_M);
	INSERT_PRODUCTMODEL(TC_2800AN_R4_S1);
	INSERT_PRODUCTMODEL(TC_2800AN_R4_S2);
	INSERT_PRODUCTMODEL(TC_2800AN_R8_S2);
	INSERT_PRODUCTMODEL(TC_H804N_HD_P);
	INSERT_PRODUCTMODEL(TC_2800AN_R16_S2_V2_0);
	INSERT_PRODUCTMODEL(TC_2800AN_R16_S4);
	INSERT_PRODUCTMODEL(TC_2800AN_R32_S4);
	INSERT_PRODUCTMODEL(TC_2816AN_SR_V2_0);
	INSERT_PRODUCTMODEL(TC_2832AN_SR_V2_0);							
	INSERT_PRODUCTMODEL(TC_2864AN_SR);
	INSERT_PRODUCTMODEL(TC_7816W);

	//add by bo 20150713
	INSERT_PRODUCTMODEL(TC_NH9206N1_MPIR_IVS);
	INSERT_PRODUCTMODEL(TC_NS324S2);
	INSERT_PRODUCTMODEL(TC_NC9000S3E_5MP_UE);
	INSERT_PRODUCTMODEL(TC_NC9001S3E_3MP_E);
	INSERT_PRODUCTMODEL(TC_NC9201S3E_3MP_EI_IR);
	INSERT_PRODUCTMODEL(TC_NH9806S6_3MPIR_I);
	INSERT_PRODUCTMODEL(TC_CC9033_3MP);
	INSERT_PRODUCTMODEL(TC_NC9401S3E_4MP_I5_E);
	INSERT_PRODUCTMODEL(TC_NC9401S3E_4MP_I_E);
	INSERT_PRODUCTMODEL(TC_NC9001S3E_2MP_ES);
	INSERT_PRODUCTMODEL(TC_NH9904S6_2MP);
	INSERT_PRODUCTMODEL(TC_NH9806S6_2MPIR_S_A);
	INSERT_PRODUCTMODEL(TC_NC9320S3E_2MP_D);
	INSERT_PRODUCTMODEL(TC_217_T2);
	INSERT_PRODUCTMODEL(TC_217_T3);
	INSERT_PRODUCTMODEL(TC_237_5MPH);
	INSERT_PRODUCTMODEL(TC_238_5MPH);
	INSERT_PRODUCTMODEL(TC_227_2MP_S_Z);
	INSERT_PRODUCTMODEL(TC_217_1MP_S);
	INSERT_PRODUCTMODEL(TC_T800GE);
	INSERT_PRODUCTMODEL(TC_H904BIX_HD_I);
	INSERT_PRODUCTMODEL(TC_T238_5MP_S_Z);
	INSERT_PRODUCTMODEL(TC_T238_6MP);
	INSERT_PRODUCTMODEL(TC_T237_6MP);
	INSERT_PRODUCTMODEL(TC_T238_6MP_B);
	INSERT_PRODUCTMODEL(TC_NR2160M7_E16);
	INSERT_PRODUCTMODEL(TC_NR2080M7_E16);
	INSERT_PRODUCTMODEL(TC_NR2080M7_E8);
	INSERT_PRODUCTMODEL(TC_NR2040M7_E8);
	INSERT_PRODUCTMODEL(TC_NR2020M7_E8);
	INSERT_PRODUCTMODEL(TC_NR2080M7_S8);
	INSERT_PRODUCTMODEL(TC_NR2040M7_S8);
	INSERT_PRODUCTMODEL(TC_NR2020M7_S8);
	INSERT_PRODUCTMODEL(TC_NR2040M7_S4);
	INSERT_PRODUCTMODEL(TC_NR2020M7_S4);	
	INSERT_PRODUCTMODEL(TC_NR2020M7_S2);

	//Add 2015 12 31
	INSERT_PRODUCTMODEL(TC_NC9400S3E_MP_C_IR30);
	INSERT_PRODUCTMODEL(TC_NC9200S3E_2MP_E_I3);
	INSERT_PRODUCTMODEL(TC_T237_2MP_S);
	INSERT_PRODUCTMODEL(TC_NC9201S3E_4MP_EI_IR30);
	INSERT_PRODUCTMODEL(TC_NC9201S3E_4MP_EI_IR30_M);
	INSERT_PRODUCTMODEL(TC_NC9101S3E_2MP_EI_IRW30_S);
	INSERT_PRODUCTMODEL(TC_NC9201S3E_2MP_EI_IR30);
	INSERT_PRODUCTMODEL(TC_NC9011S3E_3MP);
	INSERT_PRODUCTMODEL(TC_NC9501S3E_2MP_I3S);
	INSERT_PRODUCTMODEL(TC_NC9201S3E_2MP_I3S);
	INSERT_PRODUCTMODEL(TC_NH9806S6_2MPIR_S_T);
	INSERT_PRODUCTMODEL(TC_2800AN_R4_S1_V2_0);
	INSERT_PRODUCTMODEL(TC_T237_7MP);
	INSERT_PRODUCTMODEL(TC_T238_7MP);
	INSERT_PRODUCTMODEL(TC_T237_2MP_S);
	INSERT_PRODUCTMODEL(TC_NH9406S6_MPIR_S);
	INSERT_PRODUCTMODEL(TC_NH9606S6_2MPIR_S);
	INSERT_PRODUCTMODEL(TC_T1);
	INSERT_PRODUCTMODEL(TC_NC9101S3E_2MP_ES);
	INSERT_PRODUCTMODEL(T227_2MP_S_Z_V2);
	INSERT_PRODUCTMODEL(TC_H804N_HD_4SATA);
	INSERT_PRODUCTMODEL(TC_2800AN_P4_S1);
	INSERT_PRODUCTMODEL(TC_2800AN_P4_S2);
	INSERT_PRODUCTMODEL(TC_2800AN_P16_S4);
	INSERT_PRODUCTMODEL(TC_2816AN_SR_DZ15543);
	INSERT_PRODUCTMODEL(TC_NR2020M7_S1);
	INSERT_PRODUCTMODEL(TC_NR2010M7_S1);
	INSERT_PRODUCTMODEL(TC_H802_XK);
	INSERT_PRODUCTMODEL(TC_H904BIX_N);
}

CString CSearchNVS::GetProductModelName(int _iModel)
{
	CString strDevType;
	strDevType.Format(_T("0x%08x"),_iModel);
	if (m_mapProductModelName.find(_iModel) != m_mapProductModelName.end())
		strDevType = m_mapProductModelName[_iModel];

	return strDevType;
}

void CSearchNVS::InitializeDeviceTypeName()
{
	INSERT_DEVICETYPE("NVS-T");
	INSERT_DEVICETYPE("NetKeyboard");
	INSERT_DEVICETYPE("CodeDispenser");
	INSERT_DEVICETYPE("AlarmHost");
	INSERT_DEVICETYPE("NVS-S");
	INSERT_DEVICETYPE("Matrix");	
	INSERT_DEVICETYPE("Net-PU");
	INSERT_DEVICETYPE("NetEntranceguard");
	INSERT_DEVICETYPE("PC_DVR");	
	INSERT_DEVICETYPE("S-Decoder");
	INSERT_DEVICETYPE("NVS-TPlus");
	INSERT_DEVICETYPE("WIH-S");	
	INSERT_DEVICETYPE("EMBED_DVR");
	INSERT_DEVICETYPE("SMS200");
	INSERT_DEVICETYPE("ALARM_HOST");	
	INSERT_DEVICETYPE("TC_T820GE");	
	INSERT_DEVICETYPE("TC_T860GE");
	INSERT_DEVICETYPE("TC_T890GE");
	INSERT_DEVICETYPE("TC_HDC");
	INSERT_DEVICETYPE("ONVIF");
}

CString CSearchNVS::GetDeviceTypeName( int _iType )
{
	CString strDeviceType;
	strDeviceType.Format(_T("%d"),_iType);
	int iSize = m_vectDeviceType.size();
	if (_iType < iSize)
	{
		strDeviceType = m_vectDeviceType[_iType];
	}

	return strDeviceType;
}

unsigned int CSearchNVS::ThreadRefresh(VOID* pVoid)
{
	CSearchNVS* pThis = (CSearchNVS*)pVoid;
	if (pThis == NULL)
	{
		AddLog(LOG_LEVEL_ERROR,"[CSearchNVS::ThreadRefresh] Start Thread Failed! this(0x%08x)",pThis);
		return -1;
	}

	while(!pThis->m_blExit)
	{
		if (pThis->m_blRefresh)
		{
			pThis->m_blRefresh = false;
			switch(pThis->m_iConnetMode)
			{
			case 0:
				//pThis->SearchByIP();
				break;
			case 1:
				pThis->SearchByDDNS();
				break;
			case 2:
				pThis->SearchByDSM();
				break;
			default:
				break;
			}
			
		}
		Sleep(100);
	}

	return 0;
}

bool CSearchNVS::LogonReg()
{
	if (m_iRegID >= 0)
	{
		return true;
	}

	if (m_hLogonRegThread == NULL)
	{	
		m_hLogonRegThread = (HANDLE)_beginthreadex(NULL, 0, LogonRegThread, (LPVOID)this, 0, &m_dwThreadID);
		if (m_hLogonRegThread != NULL)
		{
			return true;
		}	
	}

	/*if(NSLook_Startup() == 0)
	{
		m_iRegID = NSLook_LogonServer(m_cRegIP, m_iRegPort, true);
		if (m_iRegID >= 0)
		{
			return true;
		}
		else
		{
			AddLog(LOG_LEVEL_ERROR,"[CSearchNVS::LogonReg] Logon RegServer Failed!");
		}
	}
	else
	{
		AddLog(LOG_LEVEL_ERROR,"[CSearchNVS::LogonReg] NSLook Startup Failed!");
	}*/

	return false;
}

void CSearchNVS::Refresh()
{
	m_lvServer.DeleteAllItems();
	if (m_iConnetMode==0)
	{
		SearchByIP();
	}
	else if (m_iConnetMode == 1 || m_iConnetMode == 2)
	{
		LogonReg();
		Sleep(100);
		m_blRefresh = true;	
	}
}

void CSearchNVS::SearchByIP()
{
	NetAdmin_SeekServers();
}

void CSearchNVS::SearchByDDNS()
{
	int iCount = 0;
	int iRet = NSLook_GetCount(m_iRegID,m_cRegUser,m_cRegPwd,&iCount,TYPE_DNS);
	if(iRet == 0)
	{
		if(iCount > 0)
		{
			int iPages = iCount / REG_PAGE_SIZE + 1;
			for(int i=0; i<iPages; i++)
			{
				iRet = NSLook_GetList(m_iRegID,m_cRegUser,m_cRegPwd, i, &CSearchNVS::GetDDNSList,NULL,TYPE_DNS);
				if (iRet != 0)
				{
					AddLog(LOG_LEVEL_ERROR,"[CSearchNVS::SearchByDDNS] NSLook get list failed! Ret(%d)",iRet);
				}
			}
		}
	}
	else
	{
		AddLog(LOG_LEVEL_ERROR,"[CSearchNVS::SearchByDDNS] NSLook get count failed! Ret(%d),Error(0x%08x),ID(%d),User(%s),Pwd(%s)"
			,iRet,GetLastError(),m_iRegID,m_cRegUser,m_cRegPwd);
	}
}

void CSearchNVS::SearchByDSM()
{
	int iCount = 0;
	int iRet = NSLook_GetCount(m_iRegID,m_cRegUser,m_cRegPwd,&iCount,TYPE_NVS);
	if(iRet == 0)
	{
		if(iCount > 0)
		{
			int iPages = iCount / REG_PAGE_SIZE + 1;
			for(int i=0; i<iPages; i++)
			{
				iRet = NSLook_GetList(m_iRegID,m_cRegUser,m_cRegPwd, i,NULL,&CSearchNVS::GetDSMList,TYPE_NVS);
				if (iRet != 0)
				{
					AddLog(LOG_LEVEL_ERROR,"[CSearchNVS::SearchByDSM] NSLook get list failed! Ret(%d)",iRet);
				}
			}
		}
	}
	else
	{
		AddLog(LOG_LEVEL_ERROR,"[CSearchNVS::SearchByDSM] NSLook get count failed! Ret(%d),Error(0x%08x),ID(%d),User(%s),Pwd(%s)"
			,iRet,GetLastError(),m_iRegID,m_cRegUser,m_cRegPwd);
	}
}

void __stdcall CSearchNVS::GetIPList(PTDEVICE _pDevice)
{
	__try
	{
		if (NULL != m_pSelf && NULL != _pDevice)
		{
			SendMessageTimeout(s_hWnd, MSG_NETADMIN_UPDATE_LIST, (WPARAM)_pDevice, 0, SMTO_NORMAL, 500, NULL);
		}
	}
	__except(EXCEPTION_EXECUTE_HANDLER)
	{
		AddLog(LOG_TYPE_MSG,"","SendMessageTimeout exception");
	}
}

int __stdcall CSearchNVS::GetDDNSList(int _iCount,REG_DNS *_regDNS)
{
	if (_iCount <= 0)
	{
		return 0;
	}

	if (m_pSelf)
	{
		REG_DNS *regDNSInfo = new REG_DNS[_iCount];
		memcpy(regDNSInfo, _regDNS, sizeof(REG_DNS)*_iCount);
		for (int i = 0;i < _iCount;++i)
		{
			if (m_pSelf->m_strHostIP.CompareNoCase(regDNSInfo[i].m_stDNSInfo.stNvs.cNvsIP) != 0)
			{
				m_pSelf->AddByDDNS(regDNSInfo[i]);
			}
		}
		delete[] regDNSInfo;
	}
	return _iCount;
}

int __stdcall CSearchNVS::GetDSMList(int _iCount,st_NvsSingle *_regNVS)
{
	if (_iCount <= 0)
	{
		return _iCount;
	}

	if (m_pSelf)
	{
		st_NvsSingle *regNVSInfo = new st_NvsSingle[_iCount];
		memcpy(regNVSInfo, _regNVS, sizeof(st_NvsSingle)*_iCount);
		for (int i = 0;i < _iCount;++i)
		{
			if (m_pSelf->m_strHostIP.CompareNoCase(regNVSInfo[i].cNvsIP) != 0)
			{
				m_pSelf->AddByDSM(regNVSInfo[i]);
			}			
		}
		delete[] regNVSInfo;
	}
	return _iCount;
}

int CSearchNVS::AddNvsItem(CString _strServerIP,int _iChannelNum,int _iPort
						   ,CString _strServerType,CString _strFactroyID
						   ,CString _strServerName,CString _strProxyIP)
{
	if (_strServerType.CompareNoCase(_T("S-Decoder")) == 0)
	{
		//AddLog(LOG_LEVEL_DEBUG,"--------bo----------#######################[CSearchNVS::AddNvsItem]########################[S-Decoder]\n");
		return -1;
	}

	CString strServerIP;
	CString strServerType;
	int iItem = m_lvServer.GetItemCount();
	for (int i = iItem - 1; i >= 0; --i)
	{
		strServerIP = m_lvServer.GetItemText(i,0);
		strServerType = m_lvServer.GetItemText(i,3);
		if ( (strServerIP.CompareNoCase(_strServerIP) == 0) && (strServerType.CompareNoCase(_strServerType) == 0) )
		{
			//m_lvServer.DeleteItem(i);
			return 0;
		}
	}

	CString strChannel;
	CString strPort;
	strPort.Format(_T("%d"),_iPort);
	iItem = m_lvServer.GetItemCount();
	for (int i = 1; i <= _iChannelNum; ++i)
	{
		strChannel.Format(_T("%d"),i);
		m_lvServer.InsertItem(iItem,_strServerIP);
		m_lvServer.SetItemText(iItem,1,strChannel);
		m_lvServer.SetItemText(iItem,2,strPort);
		m_lvServer.SetItemText(iItem,3,_strServerType);
		m_lvServer.SetItemText(iItem,4,_strFactroyID);
		m_lvServer.SetItemText(iItem,5,_strServerName);
		m_lvServer.SetItemText(iItem,6,_strProxyIP);
		++iItem;
	}

	return 0;
}

int CSearchNVS::AddByIP( PTDEVICE _pDevice )
{
	if (m_iConnetMode != 0)
	{
		return -1;
	}

	AddNvsItem(_pDevice->m_cIP,_pDevice->m_iChanNum,_pDevice->m_iServerPort
		,GetDeviceTypeName(_pDevice->m_iDeviceType),_pDevice->m_cFactoryID
		,_T("")/*GetProductModelName(_pDevice->m_iProductModel & 0xFFFF)*/,_T(""));

	return 0;
}

int CSearchNVS::AddByDDNS(REG_DNS &_regDNS)
{
	if (m_iConnetMode != 1 )
	{
		return -1;
	}

	AddNvsItem(_regDNS.m_stDNSInfo.stNvs.cNvsIP,_regDNS.m_stDNSInfo.m_iChannel,_regDNS.m_stDNSInfo.m_iPort
		,GetNvsType(_regDNS.m_stDNSInfo.stNvs.iNvsType),_regDNS.m_stDNSInfo.stNvs.cFactoryID
		,_regDNS.m_stDNSInfo.stNvs.cNvsName,_regDNS.m_stDNSInfo.m_stReserve.m_cReserved1);

	return 0;
}

int CSearchNVS::AddByDSM(st_NvsSingle &_regNVS)
{
	if (m_iConnetMode != 2)
	{
		return -1;
	}

	AddNvsItem(_regNVS.cNvsIP,1,3000,GetNvsType(_regNVS.iNvsType)
		,_regNVS.cFactoryID,_regNVS.cNvsName,_T(""));

	return 0;
}

CString CSearchNVS::GetNvsType(int _iNvsType)
{
	CString strNvsType;
	switch(_iNvsType)
	{
	case 1:
		strNvsType.Format(_T("%s"),"S");
		break;
	case 2:
		strNvsType.Format(_T("%s"),"T+");
		break;
	default:
		strNvsType.Format(_T("%s"),"T");
		break;
	}
	return strNvsType;
}

void CSearchNVS::OnBnClickedButtonRefresh()
{
	Refresh();
}

void CSearchNVS::OnBnClickedButtonAdd()
{
	SendMsgToMainDlg(MSG_ADDNVSITEM, 1, NULL);

#define SAFE_CLOSEHANDLE(__handle)	if (NULL != __handle)		\
									{							\
										CloseHandle(__handle);	\
										__handle = NULL;		\
									}							\

	SAFE_CLOSEHANDLE(m_hAddThread);

	m_hAddThread = (HANDLE)_beginthreadex(NULL, 0, AddNvsThreadFunc, this, 0, NULL);
	if (NULL == m_hAddThread)
	{
		AddLog(LOG_LEVEL_ERROR, "Create add nvs thread failed.\n");
		SendMsgToMainDlg(MSG_ADDNVSITEM, 0, NULL);

		return ;
	}
	this->ShowWindow(SW_HIDE);
// 	POSITION posItem=m_lvServer.GetFirstSelectedItemPosition();
// 	while(posItem)
// 	{
// 		int iItem = m_lvServer.GetNextSelectedItem(posItem);
// 		AddNvs(iItem);
// 		Sleep(400);
// 	}
// 
// 	OnOK();
}

void CSearchNVS::OnCbnSelchangeComboConnectMode()
{
	if (m_cboConnectMode.GetCount() <= 0)
	{
		m_iConnetMode = -1;
	}
	else
	{
		m_iConnetMode = m_cboConnectMode.GetCurSel();
	}

	Refresh();
}

void CSearchNVS::OnClose()
{
	if (NULL != m_hThread)
	{
		m_blExit = true;	
		if(WaitForSingleObject(m_hThread,INFINITE) != WAIT_OBJECT_0)
		{
			//SuspendThread(m_hThread);
			//TerminateThread(m_hThread,0);
		}
		CloseHandle(m_hThread);
		m_hThread = NULL;
	}
	Sleep(200);			//û˳ִͬ߳
	if (m_iRegID >= 0)
	{
		NSLook_LogoffServer(m_iRegID);
		m_iRegID = -1;
	}

	if(NULL != m_hLogonRegThread)
	{
		TerminateThread(m_hLogonRegThread, NULL);
		WaitForSingleObject(m_hLogonRegThread,INFINITE);
		CloseHandle(m_hLogonRegThread);
		m_hLogonRegThread = NULL;
	}

	CDialog::OnClose();
}

void CSearchNVS::OnOK()
{
	m_blExit = true;

	CDialog::OnOK();
}
//void CSearchNVS::OnHdnItemdblclickListServer(NMHDR* /*pNMHDR*/, LRESULT* /*pResult*/)
//{
//	POSITION posItem=m_lvServer.GetFirstSelectedItemPosition();
//	if(posItem)
//	{
//		int iItem = m_lvServer.GetNextSelectedItem(posItem);
//		AddNvs(iItem);
//	}
//}

int CSearchNVS::AddNvs( int _iItem )
{
	TNVSITEMEX tNvsItemEx = {0};
	//tNvsItemEx.m_iStructLen = sizeof(TNVSITEM);	//ӲܼӼ豸ƽ̨?????
	tNvsItemEx.m_iStructLen = sizeof(TNVSITEMEX);	//޸ONVIF豸Ӵbug
	TNVSITEM* ptNvsItem = &tNvsItemEx.m_stOldItem;
	ptNvsItem->m_serNetmode = 1;
	ptNvsItem->m_holdtime = 20;
	strcpy_s(ptNvsItem->m_username,sizeof(ptNvsItem->m_username),"Admin");
	strcpy_s(ptNvsItem->m_password,sizeof(ptNvsItem->m_password),"1111");
	if(_iItem >= 0)
	{
		int iSubItem = 0;
		CString strServerIP = m_lvServer.GetItemText(_iItem,iSubItem++);		//Server IP
		CString strChannel = m_lvServer.GetItemText(_iItem,iSubItem++);		//Channel
		CString strPort = m_lvServer.GetItemText(_iItem,iSubItem++);			//Server Port
		CString strServerType = m_lvServer.GetItemText(_iItem,iSubItem++);	//Server Type
		CString strFactoryID = m_lvServer.GetItemText(_iItem,iSubItem++);	//Factory ID
		CString strServerName = m_lvServer.GetItemText(_iItem,iSubItem++);	//Server Name
		CString strProxyIP = m_lvServer.GetItemText(_iItem,iSubItem++);		//Proxy IP

		int iPort = atoi((LPSTR)(LPCTSTR)strPort);			//Port
		if((iPort < 70)||(iPort > 45000))
		{
			MessageBox(GetText(IDS_NVS_INFO_INVALID_PORT),_T(""),MB_OK|MB_TOPMOST);
			return -1;
		}
		ptNvsItem->m_serPort = iPort;

		int iChannel = atoi((LPSTR)(LPCTSTR)strChannel);		//Channel
		ptNvsItem->m_serChan = iChannel - 1;
		//ptNvsItem->m_iAddress = ptNvsItem->m_serChan;
		ptNvsItem->m_iAddress = 0;								//֮ǰǵͨţΪ̶0

		int iConnectMode = m_cboConnectMode.GetCurSel();
		ptNvsItem->m_bUseddns = iConnectMode;
		if(1 == iConnectMode)//ddns
		{
			strcpy_s(ptNvsItem->m_serName,strServerName.GetLength()+1,(LPSTR)(LPCTSTR)strServerName);
		}
		else if (2 == iConnectMode)//dsm
		{
			strcpy_s(ptNvsItem->m_serName,strFactoryID.GetLength()+1,(LPSTR)(LPCTSTR)strFactoryID);
		}
		else//ip
		{
			strcpy_s(ptNvsItem->m_serIP,strServerIP.GetLength()+1,(LPSTR)(LPCTSTR)strServerIP);
		}	

		//Զ豸ҪӴ
		// 		if (!strProxyIP.IsEmpty())
		// 		{
		// 		    strcpy_s(ptNvsItem->m_serProxy,strProxyIP.GetLength()+1,(LPSTR)(LPCTSTR)strProxyIP);
		// 		}
		if (0 == strcmp((LPSTR)(LPCTSTR)strServerType,"ONVIF"))
		{
			tNvsItemEx.m_iDevPlatType = 1;
		}

		//ȡЭб
		//TDECPROTOCOL tProtocol = {0};
		//int iRet = DEC_ClientGetPTZprotocols(m_iID,&tProtocol);
		TDECPROTOCOL_EX tProtocolEx = {0};
		int iRet = DEC_ClientGetDevConfig(m_iID, 0, 0, CMD_DEC_CFG_PROTOCOL, &tProtocolEx, sizeof(TDECPROTOCOL_EX));
		if(ERR_SUCCESS == iRet)
		{
			strcpy_s(ptNvsItem->m_deviceType,sizeof(tProtocolEx.m_cProtocol[0]),tProtocolEx.m_cProtocol[0]);

			for(int i=0; i<tProtocolEx.m_iCount && i<MAX_PROTOCOL_NUM; i++)
			{
				if (0 == strcmp(tProtocolEx.m_cProtocol[i], "DOME_PELCO_P"))
				{
					strcpy_s(ptNvsItem->m_deviceType,sizeof(tProtocolEx.m_cProtocol[i]),tProtocolEx.m_cProtocol[i]);
					break;
				}
			}
		}
		else
		{
			AddLog(LOG_LEVEL_ERROR,"[CSearchNVS::OnBnClickedButtonAdd] Get PTZ protocols Failed! Ret(%d),Error(0x%08x),ID(%d)"
				,m_iID);
		}

		memset(tNvsItemEx.m_cEncyptPWD, 0, sizeof(tNvsItemEx.m_cEncyptPWD));	//Ƶ0
		m_pdlgMainView->ModifyNvsItem(-1,tNvsItemEx);
	}

	return 0;
}

int CSearchNVS::AddNvsEx(int _iItem)
{
	if(_iItem < 0)
	{
		return -1;
	}

	ViewServerInfo tViewServer = {0};
	tViewServer.ser_net_mode = 1;
	tViewServer.hold_time = 20;
	strcpy_s(tViewServer.ser_usr_name, sizeof(tViewServer.ser_usr_name), "Admin");
	strcpy_s(tViewServer.ser_usr_pwd, sizeof(tViewServer.ser_usr_name), "1111");

	int iSubItem = 0;
	CString strServerIP = m_lvServer.GetItemText(_iItem,iSubItem++);		//Server IP
	CString strChannel = m_lvServer.GetItemText(_iItem,iSubItem++);		//Channel
	CString strPort = m_lvServer.GetItemText(_iItem,iSubItem++);			//Server Port
	CString strServerType = m_lvServer.GetItemText(_iItem,iSubItem++);	//Server Type
	CString strFactoryID = m_lvServer.GetItemText(_iItem,iSubItem++);	//Factory ID
	CString strServerName = m_lvServer.GetItemText(_iItem,iSubItem++);	//Server Name
	CString strProxyIP = m_lvServer.GetItemText(_iItem,iSubItem++);		//Proxy IP

	int iPort = atoi((LPSTR)(LPCTSTR)strPort);			//Port
	if((iPort < 70)||(iPort > 45000))
	{
		MessageBox(GetText(IDS_NVS_INFO_INVALID_PORT),_T(""),MB_OK|MB_TOPMOST);
		return -1;
	}
	tViewServer.ser_port = iPort;

	int iChannel = atoi((LPSTR)(LPCTSTR)strChannel);		//Channel
	tViewServer.ser_ch_no = iChannel - 1;
	tViewServer.ser_ptz_addr = 0;							//֮ǰǵͨţΪ̶0

	int iConnectMode = m_cboConnectMode.GetCurSel();
	tViewServer.con_mode = iConnectMode;
	if(1 == iConnectMode)//ddns
	{
		strcpy_s(tViewServer.ser_name,strServerName.GetLength()+1,(LPSTR)(LPCTSTR)strServerName);
	}
	else if (2 == iConnectMode)//dsm
	{
		strcpy_s(tViewServer.ser_name,strFactoryID.GetLength()+1,(LPSTR)(LPCTSTR)strFactoryID);
	}
	else//ip
	{
		strcpy_s(tViewServer.ser_ip,strServerIP.GetLength()+1,(LPSTR)(LPCTSTR)strServerIP);
	}	

	if (0 == strcmp((LPSTR)(LPCTSTR)strServerType,"ONVIF"))
	{
		tViewServer.ser_type = DEVTYPE_ONVIF;
	}
	if (0 == strcmp((LPSTR)(LPCTSTR)strServerType,"ONVIF_LG"))
	{
		tViewServer.ser_type = DEVTYPE_LG;
	}
	if (0 == strcmp((LPSTR)(LPCTSTR)strServerType,"DEVTYPE_PANASONIC"))
	{
		tViewServer.ser_type = DEVTYPE_PANASONIC;
	}

	//ȡЭб
	TDECPROTOCOL_EX tProtocolEx = {0};
	int iRet = DEC_ClientGetDevConfig(m_iID, 0, 0, CMD_DEC_CFG_PROTOCOL, &tProtocolEx, sizeof(TDECPROTOCOL_EX));
	if(ERR_SUCCESS == iRet)
	{
		strcpy_s(tViewServer.ser_ptz_protocol,sizeof(tProtocolEx.m_cProtocol[0]),tProtocolEx.m_cProtocol[0]);

		for(int i=0; i<tProtocolEx.m_iCount && i<MAX_PROTOCOL_NUM; i++)
		{
			if (0 == strcmp(tProtocolEx.m_cProtocol[i], "DOME_PELCO_P"))
			{
				strcpy_s(tViewServer.ser_ptz_protocol,sizeof(tProtocolEx.m_cProtocol[i]),tProtocolEx.m_cProtocol[i]);
				break;
			}
		}
	}
	else
	{
		AddLog(LOG_LEVEL_ERROR,"[CSearchNVS::OnBnClickedButtonAdd] Get PTZ protocols Failed! Ret(%d),Error(0x%08x),ID(%d)"
			,m_iID);
	}

	memset(tViewServer.video_dec_pwd, 0, sizeof(tViewServer.video_dec_pwd));	//Ƶ0
	m_pdlgMainView->ModifyNvsServer(-1, tViewServer);

	return 0;
}

void CSearchNVS::OnNMDblclkListServer(NMHDR *pNMHDR, LRESULT *pResult)
{
	LPNMITEMACTIVATE pNMItemActivate = reinterpret_cast<LPNMITEMACTIVATE>(pNMHDR);
	AddNvsEx(pNMItemActivate->iItem);
	*pResult = 0;
}

void CSearchNVS::OnShowWindow(BOOL bShow, UINT nStatus)
{
	CDialog::OnShowWindow(bShow, nStatus);

	// TODO: Add your message handler code here
	if (FALSE == bShow)
	{
		m_blExit = true;
		if(WaitForSingleObject(m_hThread,INFINITE) != WAIT_OBJECT_0)
		{
			//SuspendThread(m_hThread);
			//TerminateThread(m_hThread,0);
		}
		CloseHandle(m_hThread);
		m_hThread = NULL;

		Sleep(500);			//û˳ִͬ߳
	}
	else
	{
		if (NetAdmin_SetNotify)
		{
			NetAdmin_SetNotify(&CSearchNVS::GetIPList);
		}

		NetAdmin_SetNetInterface(-1);
		m_cboConnectMode.SetCurSel(0);		//ÿδӵʱĬϰIP
		m_iConnetMode = 0;
		if (NULL == m_hThread)
			m_hThread = (HANDLE)_beginthreadex(NULL,0,&CSearchNVS::ThreadRefresh,this,0,NULL);
		if (m_hThread)
			m_blExit = false;

		Refresh();
	}
}

int CSearchNVS::SendMsgToMainDlg( UINT _iMsgID, WPARAM _wParam, LPARAM _lpParam )
{
	::PostMessage(m_pdlgMainView->GetSafeHwnd(), _iMsgID, _wParam, _lpParam);
	return 0;
}

unsigned int WINAPI CSearchNVS::LogonRegThread(LPVOID _Param)
{
	CSearchNVS *pThis = (CSearchNVS *)_Param;
	if (NULL == pThis)
	{
		return 1;
	}

	if(NSLook_Startup() == 0)
	{
		pThis->m_iRegID = NSLook_LogonServer(pThis->m_cRegIP, pThis->m_iRegPort, true);
		if (pThis->m_iRegID >= 0)
		{
			return 0;
		}
		else
		{
			AddLog(LOG_LEVEL_ERROR,"[CSearchNVS::LogonReg] Logon RegServer Failed!");
		}
	}
	else
	{
		AddLog(LOG_LEVEL_ERROR,"[CSearchNVS::LogonReg] NSLook Startup Failed!");
	}

	return -1;
}

LRESULT CSearchNVS::OnUpdateList( WPARAM wParam, LPARAM lParam )
{
	if (IsWindowVisible() == FALSE)
	{
		return -1;
	}

	__try
	{
		PTDEVICE pDevice = (PTDEVICE)wParam;
		if (NULL == pDevice)
		{
			return -1;
		}

		if (0 == m_strHostIP.CompareNoCase(pDevice->m_cIP))
		{
			return -1;
		}

		AddByIP(pDevice);
	}
	__except(EXCEPTION_EXECUTE_HANDLER)
	{
		AddLog(LOG_TYPE_MSG,"","OnUpdateList exception");
	}

	return 0;
}

void CSearchNVS::OnCbnSelchangeComboLocalIp()
{
	int iIndex = m_cboServerInterface.GetCurSel()-1;
	NetAdmin_SetNetInterface(iIndex);
	Sleep(200);
	Refresh();
}

LRESULT CSearchNVS::OnAddNvsItem( WPARAM wParam, LPARAM lParam )
{
	int iMsg = wParam;
	switch(iMsg)
	{
	case 0:
		{
			int iItem = (int)lParam;
			AddNvsEx(iItem);		
		}
		break;
	}
	return 0;
}
